/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.mc.mixin;

import com.mojang.blaze3d.platform.Monitor;
import com.mojang.blaze3d.platform.VideoMode;
import com.mojang.blaze3d.platform.Window;
import icyllis.modernui.ModernUI;
import icyllis.modernui.graphics.MathUtil;
import icyllis.modernui.mc.ModernUIClient;
import icyllis.modernui.mc.MuiModApi;
import icyllis.modernui.util.DisplayMetrics;
import javax.annotation.Nullable;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Window.class})
public abstract class MixinWindow {
    @Shadow
    private double f_85365_;

    @Shadow
    public abstract int m_85441_();

    @Shadow
    public abstract int m_85442_();

    @Shadow
    @Nullable
    public abstract Monitor m_85450_();

    @Inject(method={"calculateScale"}, at={@At(value="HEAD")}, cancellable=true)
    public void onCalculateScale(int guiScaleIn, boolean forceUnicode, CallbackInfoReturnable<Integer> ci) {
        int r = MuiModApi.calcGuiScales((Window)this);
        ci.setReturnValue((Object)(guiScaleIn > 0 ? MathUtil.clamp(guiScaleIn, r >> 8 & 0xF, r & 0xF) : r >> 4 & 0xF));
    }

    @Inject(method={"setGuiScale"}, at={@At(value="HEAD")})
    private void onSetGuiScale(double scaleFactor, CallbackInfo ci) {
        ModernUI ctx;
        int oldScale = (int)this.f_85365_;
        int newScale = (int)scaleFactor;
        if ((double)newScale != scaleFactor) {
            ModernUI.LOGGER.warn(ModernUI.MARKER, "Gui scale {} should be an integer, some mods break this", (Object)scaleFactor);
        }
        DisplayMetrics metrics = new DisplayMetrics();
        metrics.setToDefaults();
        metrics.widthPixels = this.m_85441_();
        metrics.heightPixels = this.m_85442_();
        metrics.density = (float)newScale * 0.5f;
        metrics.densityDpi = (int)(metrics.density * 72.0f);
        metrics.scaledDensity = ModernUIClient.sFontScale * metrics.density;
        Monitor monitor = this.m_85450_();
        if (monitor != null) {
            try {
                int[] w = new int[]{0};
                int[] h = new int[]{0};
                GLFW.glfwGetMonitorPhysicalSize((long)monitor.m_84954_(), (int[])w, (int[])h);
                VideoMode mode = monitor.m_84950_();
                metrics.xdpi = 25.4f * (float)mode.m_85332_() / (float)w[0];
                metrics.ydpi = 25.4f * (float)mode.m_85335_() / (float)h[0];
            }
            catch (NoSuchMethodError w) {
                // empty catch block
            }
        }
        if ((ctx = ModernUI.getInstance()) != null) {
            ctx.getResources().updateMetrics(metrics);
        }
        MuiModApi.dispatchOnWindowResize(this.m_85441_(), this.m_85442_(), newScale, oldScale);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Redirect(method={"<init>"}, at=@At(value="INVOKE", target="Lorg/lwjgl/glfw/GLFW;glfwWindowHint(II)V", ordinal=5), remap=false)
    private void onInit(int x, int y) {
        if (MuiModApi.get().isGLVersionPromoted()) {
            return;
        }
        GLFWErrorCallback callback = GLFW.glfwSetErrorCallback(null);
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)139272, (int)204801);
        GLFW.glfwWindowHint((int)139270, (int)1);
        int[][] versions = new int[][]{{4, 6}, {4, 5}, {4, 1}, {3, 3}};
        long window = 0L;
        try {
            for (int[] version : versions) {
                GLFW.glfwWindowHint((int)139266, (int)version[0]);
                GLFW.glfwWindowHint((int)139267, (int)version[1]);
                ModernUI.LOGGER.debug(ModernUI.MARKER, "Trying OpenGL {}.{}", (Object)version[0], (Object)version[1]);
                window = GLFW.glfwCreateWindow((int)640, (int)480, (CharSequence)"System Testing", (long)0L, (long)0L);
                if (window == 0L) continue;
                ModernUI.LOGGER.info(ModernUI.MARKER, "Promoted to OpenGL {}.{} Core Profile", (Object)version[0], (Object)version[1]);
                return;
            }
            GLFW.glfwWindowHint((int)139266, (int)3);
            GLFW.glfwWindowHint((int)139267, (int)2);
            ModernUI.LOGGER.warn(ModernUI.MARKER, "Fallback to OpenGL 3.2 Core Profile");
        }
        catch (Exception e) {
            GLFW.glfwWindowHint((int)139266, (int)3);
            GLFW.glfwWindowHint((int)139267, (int)2);
            ModernUI.LOGGER.warn(ModernUI.MARKER, "Fallback to OpenGL 3.2 Core Profile", (Throwable)e);
        }
        finally {
            if (window != 0L) {
                GLFW.glfwDestroyWindow((long)window);
            }
            GLFW.glfwWindowHint((int)131076, (int)1);
            GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)callback);
        }
    }
}

